<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';
require_once '../config/db.php';

// Consulta para listar productos con sus categorías y marcas
$sql = "SELECT p.*, c.name as cat_name, b.name as brand_name 
        FROM products p 
        LEFT JOIN categories c ON p.category_id = c.id 
        LEFT JOIN brands b ON p.brand_id = b.id 
        ORDER BY p.id DESC";
$productos = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<main class="flex-1 overflow-y-auto p-6 md:p-8 relative">
    <div class="max-w-7xl mx-auto relative z-10">
        
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="font-display font-black text-3xl text-gray-900 dark:text-white uppercase">Inventario</h1>
                <p class="text-sm text-gray-500">Gestión de SKUs y Precios.</p>
            </div>
            <a href="nuevo_producto.php" class="bg-brand-red hover:bg-brand-red_hover text-white px-6 py-3 rounded-lg font-bold uppercase tracking-wider shadow-lg shadow-brand-red/20 transition-all flex items-center gap-2">
                <i class="ri-add-circle-line text-xl"></i> Nuevo Equipo
            </a>
        </div>

        <div class="mb-4 relative">
            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <i class="ri-search-line text-gray-400"></i>
            </div>
            <input type="text" id="buscador-productos" placeholder="Buscar por SKU, nombre, categoría o marca..." 
                   class="w-full md:w-1/3 pl-10 pr-4 py-2 border border-gray-200 dark:border-white/10 rounded-lg bg-white dark:bg-brand-dark text-gray-900 dark:text-white focus:outline-none focus:border-brand-red dark:focus:border-brand-red transition-colors shadow-sm">
        </div>

        <div class="bg-white dark:bg-brand-dark rounded-xl shadow-sm border border-gray-100 dark:border-white/5 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-600 dark:text-gray-400" id="tabla-productos">
                    <thead class="bg-gray-50 dark:bg-white/5 text-xs uppercase font-bold text-gray-500 dark:text-gray-300">
                        <tr>
                            <th class="px-6 py-4">Imagen</th>
                            <th class="px-6 py-4">SKU / Nombre</th>
                            <th class="px-6 py-4">Categoría</th>
                            <th class="px-6 py-4">Precio</th>
                            <th class="px-6 py-4 text-center">Estado</th>
                            <th class="px-6 py-4 text-right">Acciones</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-white/5">
                        <?php foreach($productos as $p): ?>
                        <tr class="hover:bg-gray-50 dark:hover:bg-white/5 transition-colors fila-producto">
                            <td class="px-6 py-4">
                                <div class="w-16 h-16 rounded-lg bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 flex items-center justify-center overflow-hidden p-1 shadow-sm">
                                    <?php 
                                        // RUTA CORREGIDA: Apunta a public/img/productos
                                        $imgUrl = ($p['main_image_url'] && $p['main_image_url'] != 'default_product.jpg') 
                                            ? "../public/img/productos/" . $p['main_image_url'] 
                                            : "../public/img/default_product.jpg";
                                    ?>
                                    <img src="<?php echo $imgUrl; ?>" class="w-full h-full object-contain hover:scale-110 transition-transform duration-300">
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-[10px] font-black text-brand-red mb-0.5 tracking-wider"><?php echo $p['sku']; ?></div>
                                <div class="font-bold text-gray-900 dark:text-white text-base leading-tight max-w-xs"><?php echo $p['name']; ?></div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-bold text-gray-700 dark:text-gray-300"><?php echo $p['cat_name'] ?? 'Sin Cat.'; ?></div>
                                <div class="text-xs text-gray-400 font-bold uppercase tracking-wider"><?php echo $p['brand_name'] ?? 'Genérico'; ?></div>
                            </td>
                            <td class="px-6 py-4 font-black text-gray-900 dark:text-white text-lg">
                                S/ <?php echo number_format($p['price'], 2); ?>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-3 py-1 rounded-full text-[10px] font-black uppercase tracking-widest <?php echo $p['status']=='active' ? 'bg-green-100 text-green-700 border border-green-200' : 'bg-gray-100 text-gray-500 border border-gray-200'; ?>">
                                    <?php echo $p['status'] == 'active' ? 'VISIBLE' : 'OCULTO'; ?>
                                </span>
                            </td>
                            <td class="px-6 py-4 text-right space-x-2">
                                <a href="editar_producto.php?id=<?php echo $p['id']; ?>" class="inline-flex items-center justify-center w-9 h-9 rounded-lg bg-blue-50 text-blue-600 hover:bg-blue-600 hover:text-white transition-all shadow-sm">
                                    <i class="ri-pencil-line text-lg"></i>
                                </a>
                                
                                <form action="eliminar_producto.php" method="POST" id="form-delete-<?php echo $p['id']; ?>" class="inline-block">
                                    <input type="hidden" name="id" value="<?php echo $p['id']; ?>">
                                    <button type="button" onclick="confirmDelete(<?php echo $p['id']; ?>, '<?php echo $p['sku']; ?>')" 
                                            class="inline-flex items-center justify-center w-9 h-9 rounded-lg bg-red-50 text-red-600 hover:bg-red-600 hover:text-white transition-all shadow-sm">
                                        <i class="ri-delete-bin-line text-lg"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<script>
// FUNCIÓN PARA ELIMINAR PRODUCTO (Mantenida intacta)
function confirmDelete(id, sku) {
    const isDarkMode = document.documentElement.classList.contains('dark');

    Swal.fire({
        title: '<span class="font-display uppercase font-black">¿ELIMINAR EQUIPO?</span>',
        html: `Estás a punto de borrar el arsenal <b>${sku}</b>.<br><span class="text-sm opacity-70">Esta acción no se puede deshacer.</span>`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#D90429',
        cancelButtonColor: isDarkMode ? '#262626' : '#9ca3af',
        confirmButtonText: 'SÍ, BORRARLO',
        cancelButtonText: 'CANCELAR',
        background: isDarkMode ? '#121212' : '#ffffff',
        color: isDarkMode ? '#ffffff' : '#000000'
    }).then((result) => {
        if (result.isConfirmed) {
            document.getElementById('form-delete-' + id).submit();
        }
    });
}

// NUEVA FUNCIÓN PARA EL BUSCADOR DE INVENTARIO
document.addEventListener('DOMContentLoaded', function() {
    const buscador = document.getElementById('buscador-productos');
    const filas = document.querySelectorAll('.fila-producto');

    buscador.addEventListener('keyup', function() {
        const textoBusqueda = this.value.toLowerCase();

        filas.forEach(fila => {
            // Extrae todo el texto de la fila (SKU, nombre, categoría, marca, estado)
            const contenidoFila = fila.textContent.toLowerCase();
            
            if (contenidoFila.includes(textoBusqueda)) {
                fila.style.display = ''; // Muestra si hay coincidencia
            } else {
                fila.style.display = 'none'; // Oculta si no coincide
            }
        });
    });
});
</script>

<?php require_once 'includes/footer.php'; ?>